@extends('admin.layout.page-app')
@section('page_title', __('label.products_transactions'))
@section('tab_title', __('label.products_transactions'))

@section('content')
    @include('admin.layout.sidebar')

    <!-- Select2 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" />

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.products_transactions')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('label.products_transactions')}}</li>
                    </ol>
                </div>
            </div>

            <!-- Search && Table -->
            <div class="card custom-border-card">
                <div class="page-search mb-3">
                    <div class="sorting mr-2 w-50">
                        <label>{{__('label.sort_by')}}</label>
                        <select class="form-control" name="input_user" id="input_user">
                            <option value="0" selected>{{__('label.all_users')}}</option>
                            @for ($i = 0; $i < count($user); $i++) 
                                <option value="{{ $user[$i]['id'] }}">
                                    {{ $user[$i]['user_name'] }} | {{ $user[$i]['full_name'] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="sorting w-25">
                        <select class="form-control" name="input_status" id="input_status">
                            <option value="all">{{__('label.all_status')}}</option>
                            <option value="0">{{__('label.pending')}}</option>
                            <option value="1">{{__('label.completed')}}</option>
                        </select>
                    </div>  
                </div>

                <div class="table-responsive">
                    <table class="table table-striped text-center table-bordered" id="datatable">
                        <thead>
                            <tr>
                                <th>{{__('label.#')}}</th>
                                <th>{{__('label.users')}}</th>
                                <th>{{__('label.contact')}}</th>
                                <th>{{__('label.products')}}</th>
                                <th>{{__('label.coin')}}</th>
                                <th>{{__('label.address')}}</th>
                                <th>{{__('label.date')}}</th>
                                <th>{{__('label.action')}}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                        <tfoot>
                            <tr>
                                <td colspan="4" class="text-right"></td>
                                <td class="text-center"></td>
                                <td colspan="3" class="text-center"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <!-- Select2 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

    <script>
        $("#input_user").select2();

        const demo_mode = '{{ Demo_Mode() }}';
        function maskEmail(email) {
            const [user, domain] = email.split('@');
            const maskedUser = user.charAt(0) + '******';
            return maskedUser + '@' + domain;
        }

        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                ...dataTableDefaults,
                ajax: {
                    url: "{{ route('admin.producttransaction.index') }}",
                    data: function(d) {
                        d.input_user = $('#input_user').val();
                        d.input_status = $('#input_status').val();
                    },
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                    {
                        data: 'user',
                        name: 'user',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return `<div style="text-align: left;">${data.user_name ?? '-'}<br><span style="font-size: 14px; font-weight: 600;">${data.full_name ?? '-'}</span>`;
                        }
                    },
                    {
                        data: 'email',
                        name: 'email',
                        render: function(data, type, row) {
                            if (demo_mode == 0) {
                                const mobile = row.user.mobile_number ? row.user.country_code + ' ******' + row.user.mobile_number.slice(-4) : '';
                                const email = row.user.email ? maskEmail(row.user.email) : '';

                                return `<div style="text-align: left;">${mobile}<br><span style="font-size: 14px; font-weight: 600;">${email}</span></div>`;
                            } else {
                                return `<div style="text-align: left;">${row.user.country_code || ''} ${row.user.mobile_number || ''}<br><span style="font-size: 14px; font-weight: 600;">${row.user.email || ''}</span></div>`;
                            }
                        }
                    },
                    {
                        data: 'product',
						name: 'product',
						render: function(data) {
                            return data ? data.name : "-";
                        }
					},
                    {
                        data: 'coin',
                        name: 'coin',
                        orderable: false,
                        searchable: false,
						render: function(data) {
                            return `<span style="font-size: 18px; font-weight: 600;" class="primary-color">${data || 0}</span>`;
                        }
                    },
                    {
                        data: 'address',
                        name: 'address',
                        orderable: false,
                        searchable: false,
                        render: function(data) {
                            return data ? '<div style="text-align: left; font-size: 14px;">' + data + '</div>' : "-";
                        }
                    },
                    {
                        data: 'date',
                        name: 'date',
                        render: function(data) {
                            return data ? data : "-";
                        }
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                footerCallback: function ( row, data, start, end, display ) {
                    var api = this.api(), data;

                    // converting to interger to find total
                    var intVal = function ( i ) {
                        return typeof i === 'string' ? i.replace(/[\$,]/g, '')*1 : typeof i === 'number' ? i : 0;
                    };

                    // computing column Total of the complete result 
                    var coin = api.column(4).data()
                        .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                        }, 0 );

                    // Update footer by showing the total with the reference of the column index
                    $(api.column(1).footer() ).html("<span style='font-size: 18px; font-weight: 600;' class='primary-color'>{{__('label.total')}}</span>");
                    $(api.column(4).footer() ).html("<span style='font-size: 18px; font-weight: 600;' class='primary-color'>"+ coin + "</span>");
                },
            });

            $('#input_user, #input_status').change(function() {
                table.draw();
            });
        });

        function change_status(id) {
            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                $("#dvloader").show();
                var url = `{{ route('admin.producttransaction.show', '') }}/${id}`;

                $.ajax({
                    type: "GET",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(resp) {
                        $("#dvloader").hide();

                        if (resp.status == 200) {
                            if (resp.status_code == 1) {
                                $('#' + id).text('{{__("label.completed")}}').removeClass('hide-btn').addClass('show-btn');
                            } else {
                                $('#' + id).text('{{__("label.pending")}}').removeClass('show-btn').addClass('hide-btn');
                            }
                            toastr.success(resp.success);
                        } else {
                            toastr.error(resp.errors);
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        };
    </script>
@endsection